﻿/**********************************
* @file timer4.h
* @brief
* @author
* @version V0.0.0
* @date 2020.02.18
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _TIMER4_H
#define  _TIMER4_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU38F20.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def TIMER4_COUNT
* @brief define TIMER4 COUNT
* Details.
*/
#define TIMER4_COUNT        (250-1)  //500HZ 

/**
* @def TIMER4_PWM_DUTY_50
* @brief define pwm 50% duty
* Details.
*/
#define TIMER4_PWM_DUTY_50       (125-1)   //50%



/* Fuction Define -----------------------------------------------------------*/

/**
* @def timer4_enable()
* @brief set timer4 enable
* Details.
*/
#define timer4_enable()     {T4EN = 1;}

/**
* @def timer4_div_32()
* @brief set timer4 div 32
* Details.
*/
#define timer4_div_32()          {T4RATE_0 = 1;T4RATE_1 = 0;T4RATE_2 = 1;T4RATE_3 = 0;}

/**
* @def timer4_clk_source()  
* @brief timer4 clock source select
* Details.
*/
#define timer4_clk_source()        {T4CKS = 0;}

/**
* @def timer4_count_clr()  
* @brief timer4 count clear
* Details.
*/
#define timer4_count_clr()        {T4RSTB = 0;}

/**
* @def timer4_int_enable()  
* @brief enable timer4 int 
* Details.
*/
#define timer4_int_enable()       {TM4IF = 0; TM4IE = 1;GIE = 1;}


/* Exported functions 
--------------------------------------------------------*/

extern void timer4_init(void);
extern void timer4_set_pwm_period(unsigned int period);
extern void timer4_set_pwm_duty(unsigned int duty);


#endif